package com.ejie.ab04b.control;

import com.ejie.ab04b.service.TipoAperturaService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.TipoApertura;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;

/**
 * TipoAperturaController generated by UDA, 17-feb-2017 10:17:25.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/tipoApertura")

public class TipoAperturaController {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoAperturaController.class);

	@Autowired()
	private TipoAperturaService tipoAperturaService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  tipape071
	 *            String
	 *
	 * @param tipape071 the tipape 071
	 *  TipoApertura Objeto correspondiente al identificador indicado.
	 * @return the tipo apertura
	 */
	@RequestMapping(value = "/{tipape071}", method = RequestMethod.GET)
	public @ResponseBody TipoApertura get(@PathVariable String tipape071) {
		TipoApertura tipoApertura = new TipoApertura();
		tipoApertura.setTipape071(tipape071);
		tipoApertura = this.tipoAperturaService.find(tipoApertura);
		TipoAperturaController.logger
				.info("[GET - findBy_PK] : Obtener TipoApertura por PK");
		return tipoApertura;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 *  List<TipoApertura> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoApertura> getAll(
			@ModelAttribute TipoApertura filterTipoApertura) {
		TipoAperturaController.logger
				.info("[GET - find_ALL] : Obtener TipoApertura por filtro");
		return this.tipoAperturaService.findAll(filterTipoApertura, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  tipoApertura
	 *            TipoApertura Bean que contiene la informacion a modificar.
	 *
	 * @param tipoApertura the tipo apertura
	 *  TipoApertura Bean resultante de la modificacion.
	 * @return the tipo apertura
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipoApertura edit(
			@RequestBody TipoApertura tipoApertura) {
		TipoApertura tipoAperturaAux = this.tipoAperturaService
				.update(tipoApertura);
		TipoAperturaController.logger
				.info("[PUT] : TipoApertura actualizado correctamente");
		return tipoAperturaAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  tipoApertura
	 *            TipoApertura Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 *
	 * @param tipoApertura the tipo apertura
	 *  TipoApertura Bean resultante del proceso de creacion.
	 * @return the tipo apertura
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoApertura add(
			@RequestBody TipoApertura tipoApertura) {
		TipoApertura tipoAperturaAux = this.tipoAperturaService
				.add(tipoApertura);
		TipoAperturaController.logger
				.info("[POST] : TipoApertura insertado correctamente");
		return tipoAperturaAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  tipape071
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param tipape071 the tipape 071
	 *  TipoApertura Bean eliminado.
	 * @return the tipo apertura
	 */
	@RequestMapping(value = "/{tipape071}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipoApertura remove(@PathVariable String tipape071) {
		TipoApertura tipoApertura = new TipoApertura();
		tipoApertura.setTipape071(tipape071);
		this.tipoAperturaService.remove(tipoApertura);
		TipoAperturaController.logger
				.info("[DELETE] : TipoApertura borrado correctamente");
		return tipoApertura;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TipoAperturaController.logger.info("[GET - View] : TipoApertura");
		model.addAttribute("tipoaperturaFiltroModel", new TipoApertura());
		return "tipoapertura";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<TipoApertura> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<TipoApertura> filter(
			@RequestJsonBody(param = "filter") TipoApertura filterTipoApertura,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoAperturaController.logger
				.info("[POST - filter] : Obtener TipoAperturas");
		return this.tipoAperturaService.filter(filterTipoApertura,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  searchTipoApertura
	 *            TipoApertura Bean que contiene los parametros de busqueda a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param searchTipoApertura the search tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<TipoApertura> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<TipoApertura>> search(
			@RequestJsonBody(param = "filter") TipoApertura filterTipoApertura,
			@RequestJsonBody(param = "search") TipoApertura searchTipoApertura,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoAperturaController.logger
				.info("[POST - search] : Buscar TipoAperturas");
		return this.tipoAperturaService.search(filterTipoApertura,
				searchTipoApertura, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterTipoApertura            TipoApertura Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") TipoApertura filterTipoApertura,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoAperturaController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples TipoAperturas");
		this.tipoAperturaService.removeMultiple(filterTipoApertura,
				jqGridRequestDto, false);
		TipoAperturaController.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<JerarquiaDto<TipoApertura>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<TipoApertura>> jerarquia(
			@RequestJsonBody(param = "filter") TipoApertura filterTipoApertura,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoAperturaController.logger
				.info("[POST - jerarquia] : Obtener TipoAperturas jerarquia");
		return this.tipoAperturaService.jerarquia(filterTipoApertura,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 *  filterTipoApertura
	 *            TipoApertura Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<JerarquiaDto<TipoApertura>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<TipoApertura>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") TipoApertura filterTipoApertura,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		TipoAperturaController.logger.info(
				"[POST - jerarquia] : Obtener TipoAperturas jerarquia - Hijos");
		return this.tipoAperturaService.jerarquiaChildren(filterTipoApertura,
				jqGridRequestDto);
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterTipoApertura            Expediente Bean que contiene los parÃ¡metros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterTipoApertura the filter tipo apertura
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() TipoApertura filterTipoApertura,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<TipoApertura> listTipoApertura = this.tipoAperturaService
				.findAllLike(filterTipoApertura, jqGridRequestDto, false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.tiposApertura"),
				columns, listTipoApertura);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}

}
